<?php

class Parser
{

  /**
 	 * Fungsi untuk memparsing judul
 	 *
 	 * @param $data data judul
 	 * @return array
	 */

  public static function title($data)
  {
    # Judul utama = judul terjemahan : anak judul / pernyataan tanggung jawab
    $_return = array(
      'main' => null,
      'pararel' => null,
      'child' => null,
      'sor' => null,
    );

    // split data
    $title = preg_split('/=|:|\//', $data);

    // get main title
    $_return['main'] = trim($title[0]);

    // get pararel title
    if (preg_match('/=/', $data)) {
      $_return['pararel'] = trim($title[1]);
    }

    // get child title
    if (preg_match('/:/', $data)) {
      $title = preg_split('/:|\//', $data);
      $_return['child'] = $title[1];
    }

    // get sor
    if (preg_match('/\//', $data)) {
      $_return['sor'] = self::sor($title[count($title) - 1]);
    }

    return $_return;
  }

  public static function sor($sor)
  {
    return $sor;
  }

  public static function collation($data)
  {
    $_return = array(
      'extent' => null,
      'other_physical_details' => null,
      'dimensions' => null
    );

    $collation = preg_split('/:|;/', $data);

    $_return['extent'] = trim($collation[0]);

    if (preg_match('/:/', $data)) {
      $_return['other_physical_details'] = trim($collation[1]);
    }

    if (preg_match('/;/', $data)) {
      $collation = preg_split('/;/', $data);
      $_return['dimensions'] = trim($collation[1]);
    }

    return $_return;
  }

  public static function series($data)
  {
    $_return = array(
      'title' => null,
      'volume' => null
    );

  	if (preg_match('/\(/', $data)) {
  		$series = preg_split('/\(/', $data);
  		$_return['title'] = trim($series[0]);
  		$_series_volume = trim($series[1]);
  	    $_return['volume'] = substr($_series_volume,0,strlen($_series_volume)-1);
  	} else {
  		$_return['title'] = $data;
  	}

    return $_return;
  }

  public static function author($data)
  {
    $_return = array();
    $authors = explode(';', $data);
	$_XX = 0;
    $p = 0;
    $o = 0;
    $c = 0;
    foreach ($authors as $author) {
      $_a = explode('*', $author);
      $type = (isset($_a[1])) ? trim($_a[1]) : 'p';
      switch ($type) {
        case 'p':
		  if ($p > 0) {
			if ($_XX > 0) {
			  $tag = '700';
			} else {
			  $tag = '100';
			  $_XX++;
			}
		  } else {
			if ($_XX > 0) {
			  $tag = '700';
			} else {
			  $tag = '100';
			  $_XX++;
			}
		  }
          //$tag = ($p > 0) ? '700' : '100';
          $p++;
          break;
        case 'o':
		  if ($o > 0) {
			if ($_XX > 0) {
			  $tag = '710';
			} else {
			  $tag = '110';
			  $_XX++;
			}
		  } else {
			if ($_XX > 0) {
			  $tag = '710';
			} else {
			  $tag = '110';
			  $_XX++;
			}
		  }
          //$tag = ($o > 0) ? '710' : '110';
          $o++;
          break;
        case 'c':
		  if ($c > 0) {
			if ($_XX > 0) {
			  $tag = '711';
			} else {
			  $tag = '111';
			  $_XX++;
			}
		  } else {
			if ($_XX > 0) {
			  $tag = '711';
			} else {
			  $tag = '111';
			  $_XX++;
			}
		  }
          //$tag = ($c > 0) ? '711' : '111';
          $c++;
          break;
        default:
          $tag = '100';
          break;
      }
      $_return[] = array(
        'tag' => $tag,
        'subfield' => 'a',
        'value' => trim($_a[0])
      );
    }

    return $_return;
  }

  public static function subject($data)
  {
    $_return = array();
    $subjects = explode(';', $data);
    foreach ($subjects as $subject) {
      $_s = explode('*', $subject);
      $type = (isset($_s[1])) ? trim($_s[1]) : 't';
      switch ($type) {
        case 'n':
          $tag = '600';
          break;
        case 'o':
          $tag = '610';
          break;
        case 'c':
          $tag = '611';
          break;
        case 'g':
          $tag = '651';
          break;

        default:
          $tag = '650';
          break;
      }
      $_return[] = array(
        'tag' => $tag,
        'subfield' => 'a',
        'value' => trim($_s[0])
      );
    }

    return $_return;
  }
}
