<?php

require __DIR__ . './../config.php';
require __DIR__ . './../connection.php';
require __DIR__ . './../builder.php';
require __DIR__ . './../parser.php';

// ----------------------------------------------------------------------------
// Get biblio data
// ----------------------------------------------------------------------------
$sql = 'SELECT b.*, z.frequency_id,
               GROUP_CONCAT(DISTINCT a.author_name, \'*\', a.authority_type ORDER BY a.author_name SEPARATOR \'; \') AS XX0,
               GROUP_CONCAT(DISTINCT t.topic, \'*\', t.topic_type ORDER BY t.topic SEPARATOR \'; \') AS XX6
        FROM
               search_biblio b,
               biblio_author x,
               mst_author a,
               biblio_topic y,
               mst_topic t,
               biblio z
        WHERE
               b.biblio_id = x.biblio_id
               AND b.biblio_id = z.biblio_id
               AND x.author_id = a.author_id
               AND b.biblio_id = y.biblio_id
               AND y.topic_id = t.topic_id
        GROUP BY b.biblio_id
        LIMIT ' . $_POST['skip'] . ', ' . $_POST['get'];

$sth = $dbh->prepare($sql);
$sth->execute();
$biblios = $sth->fetchAll(PDO::FETCH_ASSOC);
$n = 0;
foreach ($biblios as $biblio) {

  // --------------------------------------------------------------------------
  // Parse
  // --------------------------------------------------------------------------
  $title = Parser::title($biblio['title']);
  $collation = Parser::collation($biblio['collation']);
  $series = Parser::series($biblio['series_title']);
  $authors = Parser::author($biblio['XX0']);
  $subjects = Parser::subject($biblio['XX6']);

  // --------------------------------------------------------------------------
  // Build
  // --------------------------------------------------------------------------
  $builder = new Builder;
  $builder->setBiblioId($biblio['biblio_id']);
  $builder->controlfield('001', $biblio['biblio_id']);
  $builder->subfield('245', 'a', $title['main']);
  $builder->subfield('245', 'b', $title['child']);
  $builder->subfield('245', 'c', $title['sor']);
  $builder->subfield('245', 'l', $title['pararel']);
  $builder->subfield('245', 'h', $biblio['gmd']);
  $builder->subfield('250', 'a', $biblio['edition']);
  if ($biblio['frequency_id']) {
    $builder->subfield('22', 'a', $biblio['isbn_issn']);
  } else {
    $builder->subfield('20', 'a', $biblio['isbn_issn']);
  }
  $builder->subfield('260', 'a', $biblio['publish_place']);
  $builder->subfield('260', 'b', $biblio['publisher']);
  $builder->subfield('260', 'c', $biblio['publish_year']);
  $builder->subfield('300', 'a', $collation['extent']);
  $builder->subfield('300', 'b', $collation['other_physical_details']);
  $builder->subfield('300', 'c', $collation['dimensions']);
  $builder->subfield('440', 'a', $series['title']);
  $builder->subfield('440', 'v', $series['volume']);
  $builder->subfield('084', 'a', $biblio['call_number']);
  $builder->subfield('041', 'a', $biblio['language']);
  $builder->subfield('082', 'a', $biblio['classification']);
  $builder->subfield('500', 'a', $biblio['notes']);
  foreach ($authors as $author) {
    $builder->subfield($author['tag'], $author['subfield'], $author['value']);
  }
  foreach ($subjects as $subject) {
    $builder->subfield($subject['tag'], $subject['subfield'], $subject['value']);
  }

  // save to database
  $builder->save($dbh);

  $n++;

}

echo $n;
