<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>S2M</title>

    <link rel="stylesheet" href="assets/css/bootstrap.css">
    <link rel="stylesheet" href="assets/css/style.css">
  </head>
  <body>

    <div class="container-fluid">

      <nav class="navbar navbar-toggleable-md navbar-light bg-faded fixed-top">
        <button class="navbar-toggler navbar-toggler-right" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
          <span class="navbar-toggler-icon"></span>
        </button>
        <a class="navbar-brand" href="#">SLiMS to MARC</a>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
          <ul class="navbar-nav mr-auto">
            <!-- <li class="nav-item active">
              <a class="nav-link" href="#">Home <span class="sr-only">(current)</span></a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#">Convert</a>
            </li>
            <li class="nav-item">
              <a class="nav-link" href="#">Export</a>
            </li> -->
          </ul>
          <!-- <form class="form-inline my-2 my-lg-0">
            <input class="form-control mr-sm-2" type="text" placeholder="Search">
            <button class="btn btn-outline-success my-2 my-sm-0" type="submit">Search</button>
          </form> -->
        </div>
      </nav>

      <div style="margin-top: 64px;">
        <div class="card-columns">

          <!-- // DATABASE CARD -->
          <div class="card db-card">
            <div class="card-block">
              <h4 class="card-title">Database Setting</h4>
              <form name="database" id="db-form">
                <div class="form-group">
                  <label for="database-host">Host</label>
                  <input type="text" class="form-control" id="database-host" placeholder="localhost" name="host">
                </div>
                <div class="form-group">
                  <label for="database-port">Port</label>
                  <input type="text" class="form-control" id="database-port" placeholder="3306" name="port">
                </div>
                <div class="form-group">
                  <label for="database-name">Database name</label>
                  <input type="text" class="form-control" id="database-name" placeholder="senayandb" name="name">
                </div>
                <div class="form-group">
                  <label for="database-username">Username</label>
                  <input type="text" class="form-control" id="database-username" placeholder="Enter database username" name="user">
                </div>
                <div class="form-group">
                  <label for="database-password">Password</label>
                  <input type="text" class="form-control" id="database-password" placeholder="Enter database password" name="pass">
                </div>
                <button type="submit" name="submit" class="btn btn-outline-primary">Test connection</button>
                <footer class="text-right">
                  <small class="text-muted">
                    <span id="db-status"></span>
                  </small>
                </footer>
              </form>
            </div>
          </div>

          <!-- // TABLE BIBLIO_MARC STATUS -->
          <div class="card hide biblio_marc-error">
            <div class="card-block biblio-marc-table">
              <h3 class="card-title color danger">ERROR!</h3>
              <p class="card-text">Table <code>biblio_marc</code> not available!</p>
              <a href="#" id="fix-biblio_marc" class="btn btn-primary">FIX IT! </a>
            </div>
          </div>

          <div class="card card-inverse card-primary p-3 text-center biblio_marc-success hide">
            <blockquote class="card-blockquote">
              <p>Semua yang dibutuhkan telah siap, anda sudah dapat memulai untuk mengkonversi data SLiMS ke Marc</p>
              <a href="#" id="do-konversi" class="btn btn-warning">KONVERSIKAN SEKARANG</a>
              <footer>
                <small>
                  SLiMS to <cite title="Source Title">Marc</cite>
                </small>
              </footer>
            </blockquote>
          </div>

          <!-- Konversi status -->
          <div class="card hide" id="konversi-status">
            <div class="card-block">
              <h4 class="card-title">Konversi status...</h4>
              <p class="message-status"></p>
            </div>
          </div>

          <!-- Data statistic -->
          <div class="card hide statistict">
            <div class="card-block">
              <h4>Collection Statistic</h4>
            </div>
            <ul class="list-group">
              <li class="list-group-item justify-content-between">
                Bibliography
                <span class="badge badge-default badge-pill" id="count-biblio">0</span>
              </li>
              <li class="list-group-item justify-content-between">
                Items
                <span class="badge badge-default badge-pill" id="count-item">0</span>
              </li>
              <li class="list-group-item justify-content-between">
                Biblio Marc
                <span class="badge badge-default badge-pill" id="count-biblio-marc">0</span>
              </li>
              <li class="list-group-item justify-content-between">
                Biblio Index
                <span class="badge badge-default badge-pill" id="count-biblio-index">0</span>
              </li>
            </ul>
          </div>

          <div class="card card-inverse card-info p-3 text-center">
            <blockquote class="card-blockquote">
              <p>Proses konversi menggunakan tabel <code>search_biblio</code>
                Pastikan anda sudah melakukan <i>indexing</i> terlebih dahulu (dengan menggunakan model "index" pada berkas konfigurasi sysconfig.inc.php) sebelum melakukan konversi.
              </p>
              <p><i>Indexing</i> dapat dilakukan pada SLiMS, masuk sebagai administrator dan akses menu<br>
                <code>Sistem > Indeks Biblio</code>
              </p>
              <!-- <a href="#" class="btn btn-primary">LAKUKAN PENGINDEKSAN</a> -->
              <footer>
                <small>
                  <!-- SLiMS to <cite title="Source Title">Marc</cite> -->
                </small>
              </footer>
            </blockquote>
          </div>

        </div>
      </div>

    </div>

    <script type="text/javascript" src="assets/js/jquery.min.js"></script>
    <script type="text/javascript" src="assets/js/tether.min.js"></script>
    <script type="text/javascript" src="assets/js/bootstrap.min.js"></script>
    <script type="text/javascript" src="assets/js/custom.js"></script>

  </body>
</html>
