<?php


/**
 *
 */
class Builder
{

  private $data = array();
  private $biblio_id = 0;
  private $error = null;

  public function setBiblioId($biblio_id)
  {
    $this->biblio_id = $biblio_id;
  }

  public function controlfield($tag, $value)
  {
    if (!empty($value)) {
      $this->data[$tag] = $value;
    }
  }

  /**
 	 * Add field function
 	 *
 	 * @param $tag marc tag
   * @param $code marc code
   * @param $value value of marc tag code
 	 * @return void
	 */
  public function subfield($tag, $code, $value)
  {
    if (!empty($value)) {
      $this->data[$tag][] = array($code => $value);
    }
  }

  public function dump()
  {
    header('Content-Type: application/json');
    echo self::tokenize($this->data);
  }

  public function save($obj_db)
  {
    $save = $obj_db->prepare('INSERT INTO biblio_marc (biblio_id, marc_tag,
            marc_indicator, marc_data, input_date, last_update)
            VALUE (?,?,?,?,?,?)');
    foreach ($this->data as $tag => $data) {

      $array = array();

      $array[] = $this->biblio_id;
      $array[] = $tag;
      $array[] = '##';
      $array[] = json_encode($data);
      $array[] = date('Y-m-d H:i:s');
      $array[] = date('Y-m-d H:i:s');

      $save->execute($array);

      if (!$save) {
        $this->error = $obj_db->errorInfo();
      }
    }
  }

  public function serialize()
  {
    return serialize($this->data);
  }

  public function tokenize()
  {
    return json_encode($this->data);
  }

}
