'use strict';

(function () {

// ----------------------------------------------------------------------------
// Check local storage
// ----------------------------------------------------------------------------
if (typeof(Storage) == "undefined") {
  console.error("Sorry! No Web Storage support...")
}

// ----------------------------------------------------------------------------
// clear localStoreage
// for debug purpose only
// ----------------------------------------------------------------------------
// localStorage.clear()

// ----------------------------------------------------------------------------
// Save database
// ----------------------------------------------------------------------------
var host, port, name, user, pass, lS = localStorage, s, success, error
s = $('#db-status')
success = 'color success'
error = 'color danger'
host = $('#database-host')
port = $('#database-port')
name = $('#database-name')
user = $('#database-username')
pass = $('#database-password')

// ----------------------------------------------------------------------------
// Get stored database setting and put into form
// ----------------------------------------------------------------------------
host.val(lS.host)
port.val(lS.port)
name.val(lS.name)
user.val(lS.user)
pass.val(lS.pass)

// initialize
if (lS.length > 0) {
  init()
}

// ----------------------------------------------------------------------------
// Event Register
// ----------------------------------------------------------------------------
$('#db-form').on('submit', function (e) {
  e.preventDefault()
  lS.host = host.val()
  lS.port = port.val()
  lS.name = name.val()
  lS.user = user.val()
  lS.pass = pass.val()
  init()
})

$('#do-konversi').on('click', function (e) {
  e.preventDefault()
  $('.message-status').text('')
  $('#konversi-status').removeClass('hide')
  doConversion(100)
})

// ----------------------------------------------------------------------------
// Import table biblio_marc
// ----------------------------------------------------------------------------
$('#fix-biblio_marc').on('click', function (e) {
  e.preventDefault()
  importTable('biblio_marc', function (err, msg) {
    if (err) {
      console.log(msg);
    } else {
      init()
    }
  })
})

// ----------------------------------------------------------------------------
// Update element
// ----------------------------------------------------------------------------
function updateElementBiblioMarc(available) {
  if (available) {
    $('.biblio_marc-success, .statistict').removeClass('hide')
    $('.biblio_marc-error').addClass('hide')
  } else {
    $('.biblio_marc-success, .statistict').addClass('hide')
    $('.biblio_marc-error').removeClass('hide')
  }
}

function updateStatistic() {
  // biblio
  count('biblio', 'biblio_id', function (data) {
    $('#count-biblio').text(data)
  })
  // items
  count('item', 'item_id', function (data) {
    $('#count-item').text(data)
  })
  // biblio_marc
  count('biblio_marc', 'biblio_id', function (data) {
    $('#count-biblio-marc').text(data)
  })
  // search_biblio
  count('search_biblio', 'biblio_id', function (data) {
    $('#count-biblio-index').text(data)
  })
}

// ----------------------------------------------------------------------------
// init function
// ----------------------------------------------------------------------------
function init() {
  checkConnection(function (connected, err) {
    if (connected) {
      s.text('Database conected!').removeClass(error).addClass(success)
      $('.db-card').removeClass('card-outline-danger').addClass('card-outline-primary')
      checkTable('biblio_marc', function (available) {
        updateElementBiblioMarc(available);
        if (available) {
          updateStatistic()
        }
      })
    } else {
      s.text(err).removeClass(success).addClass(error)
      $('.db-card').removeClass('card-outline-primary').addClass('card-outline-danger')
    }
  })
}

// ----------------------------------------------------------------------------
// Check connection function
// ----------------------------------------------------------------------------
function checkConnection(callback) {
  $.ajax({
    url: 'lib/connection.php',
    method: 'POST',
    data: $('#db-form').serialize()
  }).done(function (msg) {
    if (msg == 1) {
      callback(true)
    } else {
      callback(false, msg)
    }

  })
}

// ----------------------------------------------------------------------------
// Check biblio_marc table function
// ----------------------------------------------------------------------------
function checkTable(table, callback) {
  var available = false, data
  data = 'table=' + table + '&'
  data += $('#db-form').serialize()
  $.ajax({
    url: 'lib/check-table.php',
    method: 'POST',
    data: data
  }).done(function (msg){
    if (msg == 1) {
      available = true
    } else {
      available = false
    }
    callback(available)
  })
}

// ----------------------------------------------------------------------------
// Import biblio_marc function
// ----------------------------------------------------------------------------
function importTable(table, callback) {
  var data
  data = 'table=' + table + '&'
  data += $('#db-form').serialize()
  $.ajax({
    url: 'lib/import-table.php',
    method: 'POST',
    data: data
  }).done(function (msg) {
    if (msg == 1) {
      callback(false)
    } else {
      callback(true, msg)
    }
  })
}

// ----------------------------------------------------------------------------
// Count table
// ----------------------------------------------------------------------------
function count(table, groupBy, callback) {
  var data
  data = 'table=' + table + '&group=' + groupBy + '&'
  data += $('#db-form').serialize()
  $.ajax({
    url: 'lib/count-table.php',
    method: 'POST',
    data: data
  }).done(function (msg) {
    callback(msg)
  })
}

// ----------------------------------------------------------------------------
// Conversion is runing
// ----------------------------------------------------------------------------
function doConversion(offset) {
  // get biblio data
  var biblio, forLoop
  count('biblio', 'biblio_id', function (data) {
    biblio = data
    forLoop = Math.ceil(biblio / offset)

    for (var i = 0; i < forLoop; i++) {
      sendRequest(offset, offset*i)
    }

  })
}

async function sendRequest(offset, skip) {
  // show status
  var data
  data = 'get=' + offset + '&skip=' + skip + '&'
  data += $('#db-form').serialize()
  $.ajax({
    url: 'lib/conversion.php',
    method: 'POST',
    data: data
  }).done(function (msg) {
    console.log(msg);
    if (msg < offset && msg > 0) {
      $('.message-status').prepend('<div>Mengkonversi data dari ' + (((skip/offset)*offset)+1) + ' sampai ' + (skip+parseInt(msg)) + '...</div>')
      $('.message-status').prepend('<div>DONE!</div>')
    } else if (msg == offset) {
      $('.message-status').prepend('<div>Mengkonversi data dari ' + (((skip/offset)*offset)+1) + ' sampai ' + (skip+offset) + '...</div>')
    }

    updateStatistic()
  })
}

})();
